// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/media/router/media_router.mojom
//

package org.chromium.mojom.media_router.interfaces;

class MediaRouteProvider_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<MediaRouteProvider, MediaRouteProvider.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<MediaRouteProvider, MediaRouteProvider.Proxy>() {
    
        public String getName() {
            return "media_router::interfaces::MediaRouteProvider";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, MediaRouteProvider impl) {
            return new Stub(core, impl);
        }
    
        public MediaRouteProvider[] buildArray(int size) {
          return new MediaRouteProvider[size];
        }
    };

    private static final int CREATE_ROUTE_ORDINAL = 0;
    private static final int JOIN_ROUTE_ORDINAL = 1;
    private static final int CLOSE_ROUTE_ORDINAL = 2;
    private static final int SEND_ROUTE_MESSAGE_ORDINAL = 3;
    private static final int SEND_ROUTE_BINARY_MESSAGE_ORDINAL = 4;
    private static final int START_OBSERVING_MEDIA_SINKS_ORDINAL = 5;
    private static final int STOP_OBSERVING_MEDIA_SINKS_ORDINAL = 6;
    private static final int START_OBSERVING_MEDIA_ROUTES_ORDINAL = 7;
    private static final int STOP_OBSERVING_MEDIA_ROUTES_ORDINAL = 8;
    private static final int LISTEN_FOR_ROUTE_MESSAGES_ORDINAL = 9;
    private static final int STOP_LISTENING_FOR_ROUTE_MESSAGES_ORDINAL = 10;
    private static final int ON_PRESENTATION_SESSION_DETACHED_ORDINAL = 11;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements MediaRouteProvider.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void createRoute(String mediaSource, String sinkId, String originalPresentationId, String origin, int tabId, CreateRouteResponse callback) {
            MediaRouteProviderCreateRouteParams _message = new MediaRouteProviderCreateRouteParams();
            _message.mediaSource = mediaSource;
            _message.sinkId = sinkId;
            _message.originalPresentationId = originalPresentationId;
            _message.origin = origin;
            _message.tabId = tabId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CREATE_ROUTE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaRouteProviderCreateRouteResponseParamsForwardToCallback(callback));
        }

        @Override
        public void joinRoute(String mediaSource, String presentationId, String origin, int tabId, JoinRouteResponse callback) {
            MediaRouteProviderJoinRouteParams _message = new MediaRouteProviderJoinRouteParams();
            _message.mediaSource = mediaSource;
            _message.presentationId = presentationId;
            _message.origin = origin;
            _message.tabId = tabId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    JOIN_ROUTE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaRouteProviderJoinRouteResponseParamsForwardToCallback(callback));
        }

        @Override
        public void closeRoute(String routeId) {
            MediaRouteProviderCloseRouteParams _message = new MediaRouteProviderCloseRouteParams();
            _message.routeId = routeId;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CLOSE_ROUTE_ORDINAL)));
        }

        @Override
        public void sendRouteMessage(String mediaRouteId, String message, SendRouteMessageResponse callback) {
            MediaRouteProviderSendRouteMessageParams _message = new MediaRouteProviderSendRouteMessageParams();
            _message.mediaRouteId = mediaRouteId;
            _message.message = message;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SEND_ROUTE_MESSAGE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaRouteProviderSendRouteMessageResponseParamsForwardToCallback(callback));
        }

        @Override
        public void sendRouteBinaryMessage(String mediaRouteId, byte[] data, SendRouteBinaryMessageResponse callback) {
            MediaRouteProviderSendRouteBinaryMessageParams _message = new MediaRouteProviderSendRouteBinaryMessageParams();
            _message.mediaRouteId = mediaRouteId;
            _message.data = data;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SEND_ROUTE_BINARY_MESSAGE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaRouteProviderSendRouteBinaryMessageResponseParamsForwardToCallback(callback));
        }

        @Override
        public void startObservingMediaSinks(String mediaSource) {
            MediaRouteProviderStartObservingMediaSinksParams _message = new MediaRouteProviderStartObservingMediaSinksParams();
            _message.mediaSource = mediaSource;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(START_OBSERVING_MEDIA_SINKS_ORDINAL)));
        }

        @Override
        public void stopObservingMediaSinks(String mediaSource) {
            MediaRouteProviderStopObservingMediaSinksParams _message = new MediaRouteProviderStopObservingMediaSinksParams();
            _message.mediaSource = mediaSource;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(STOP_OBSERVING_MEDIA_SINKS_ORDINAL)));
        }

        @Override
        public void startObservingMediaRoutes() {
            MediaRouteProviderStartObservingMediaRoutesParams _message = new MediaRouteProviderStartObservingMediaRoutesParams();
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(START_OBSERVING_MEDIA_ROUTES_ORDINAL)));
        }

        @Override
        public void stopObservingMediaRoutes() {
            MediaRouteProviderStopObservingMediaRoutesParams _message = new MediaRouteProviderStopObservingMediaRoutesParams();
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(STOP_OBSERVING_MEDIA_ROUTES_ORDINAL)));
        }

        @Override
        public void listenForRouteMessages(String routeId, ListenForRouteMessagesResponse callback) {
            MediaRouteProviderListenForRouteMessagesParams _message = new MediaRouteProviderListenForRouteMessagesParams();
            _message.routeId = routeId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    LISTEN_FOR_ROUTE_MESSAGES_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaRouteProviderListenForRouteMessagesResponseParamsForwardToCallback(callback));
        }

        @Override
        public void stopListeningForRouteMessages(String routeId) {
            MediaRouteProviderStopListeningForRouteMessagesParams _message = new MediaRouteProviderStopListeningForRouteMessagesParams();
            _message.routeId = routeId;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(STOP_LISTENING_FOR_ROUTE_MESSAGES_ORDINAL)));
        }

        @Override
        public void onPresentationSessionDetached(String routeId) {
            MediaRouteProviderOnPresentationSessionDetachedParams _message = new MediaRouteProviderOnPresentationSessionDetachedParams();
            _message.routeId = routeId;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(ON_PRESENTATION_SESSION_DETACHED_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<MediaRouteProvider> {

        Stub(org.chromium.mojo.system.Core core, MediaRouteProvider impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaRouteProvider_Internal.MANAGER, messageWithHeader);
                    case CLOSE_ROUTE_ORDINAL: {
                        MediaRouteProviderCloseRouteParams data =
                                MediaRouteProviderCloseRouteParams.deserialize(messageWithHeader.getPayload());
                        getImpl().closeRoute(data.routeId);
                        return true;
                    }
                    case START_OBSERVING_MEDIA_SINKS_ORDINAL: {
                        MediaRouteProviderStartObservingMediaSinksParams data =
                                MediaRouteProviderStartObservingMediaSinksParams.deserialize(messageWithHeader.getPayload());
                        getImpl().startObservingMediaSinks(data.mediaSource);
                        return true;
                    }
                    case STOP_OBSERVING_MEDIA_SINKS_ORDINAL: {
                        MediaRouteProviderStopObservingMediaSinksParams data =
                                MediaRouteProviderStopObservingMediaSinksParams.deserialize(messageWithHeader.getPayload());
                        getImpl().stopObservingMediaSinks(data.mediaSource);
                        return true;
                    }
                    case START_OBSERVING_MEDIA_ROUTES_ORDINAL: {
                        MediaRouteProviderStartObservingMediaRoutesParams.deserialize(messageWithHeader.getPayload());
                        getImpl().startObservingMediaRoutes();
                        return true;
                    }
                    case STOP_OBSERVING_MEDIA_ROUTES_ORDINAL: {
                        MediaRouteProviderStopObservingMediaRoutesParams.deserialize(messageWithHeader.getPayload());
                        getImpl().stopObservingMediaRoutes();
                        return true;
                    }
                    case STOP_LISTENING_FOR_ROUTE_MESSAGES_ORDINAL: {
                        MediaRouteProviderStopListeningForRouteMessagesParams data =
                                MediaRouteProviderStopListeningForRouteMessagesParams.deserialize(messageWithHeader.getPayload());
                        getImpl().stopListeningForRouteMessages(data.routeId);
                        return true;
                    }
                    case ON_PRESENTATION_SESSION_DETACHED_ORDINAL: {
                        MediaRouteProviderOnPresentationSessionDetachedParams data =
                                MediaRouteProviderOnPresentationSessionDetachedParams.deserialize(messageWithHeader.getPayload());
                        getImpl().onPresentationSessionDetached(data.routeId);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaRouteProvider_Internal.MANAGER, messageWithHeader, receiver);
                    case CREATE_ROUTE_ORDINAL: {
                        MediaRouteProviderCreateRouteParams data =
                                MediaRouteProviderCreateRouteParams.deserialize(messageWithHeader.getPayload());
                        getImpl().createRoute(data.mediaSource, data.sinkId, data.originalPresentationId, data.origin, data.tabId, new MediaRouteProviderCreateRouteResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case JOIN_ROUTE_ORDINAL: {
                        MediaRouteProviderJoinRouteParams data =
                                MediaRouteProviderJoinRouteParams.deserialize(messageWithHeader.getPayload());
                        getImpl().joinRoute(data.mediaSource, data.presentationId, data.origin, data.tabId, new MediaRouteProviderJoinRouteResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case SEND_ROUTE_MESSAGE_ORDINAL: {
                        MediaRouteProviderSendRouteMessageParams data =
                                MediaRouteProviderSendRouteMessageParams.deserialize(messageWithHeader.getPayload());
                        getImpl().sendRouteMessage(data.mediaRouteId, data.message, new MediaRouteProviderSendRouteMessageResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case SEND_ROUTE_BINARY_MESSAGE_ORDINAL: {
                        MediaRouteProviderSendRouteBinaryMessageParams data =
                                MediaRouteProviderSendRouteBinaryMessageParams.deserialize(messageWithHeader.getPayload());
                        getImpl().sendRouteBinaryMessage(data.mediaRouteId, data.data, new MediaRouteProviderSendRouteBinaryMessageResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case LISTEN_FOR_ROUTE_MESSAGES_ORDINAL: {
                        MediaRouteProviderListenForRouteMessagesParams data =
                                MediaRouteProviderListenForRouteMessagesParams.deserialize(messageWithHeader.getPayload());
                        getImpl().listenForRouteMessages(data.routeId, new MediaRouteProviderListenForRouteMessagesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class MediaRouteProviderCreateRouteParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 48;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(48, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String mediaSource;
        public String sinkId;
        public String originalPresentationId;
        public String origin;
        public int tabId;
    
        private MediaRouteProviderCreateRouteParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderCreateRouteParams() {
            this(0);
        }
    
        public static MediaRouteProviderCreateRouteParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderCreateRouteParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderCreateRouteParams result = new MediaRouteProviderCreateRouteParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mediaSource = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sinkId = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.originalPresentationId = decoder0.readString(24, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(32, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.tabId = decoder0.readInt(40);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mediaSource, 8, false);
            encoder0.encode(sinkId, 16, false);
            encoder0.encode(originalPresentationId, 24, false);
            encoder0.encode(origin, 32, false);
            encoder0.encode(tabId, 40);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderCreateRouteParams other = (MediaRouteProviderCreateRouteParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaSource, other.mediaSource))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sinkId, other.sinkId))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.originalPresentationId, other.originalPresentationId))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            if (this.tabId != other.tabId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaSource);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sinkId);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(originalPresentationId);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(tabId);
            return result;
        }
    }

    static final class MediaRouteProviderCreateRouteResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public MediaRoute route;
        public String errorText;
    
        private MediaRouteProviderCreateRouteResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderCreateRouteResponseParams() {
            this(0);
        }
    
        public static MediaRouteProviderCreateRouteResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderCreateRouteResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderCreateRouteResponseParams result = new MediaRouteProviderCreateRouteResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                result.route = MediaRoute.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.errorText = decoder0.readString(16, true);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(route, 8, true);
            encoder0.encode(errorText, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderCreateRouteResponseParams other = (MediaRouteProviderCreateRouteResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.route, other.route))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.errorText, other.errorText))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(route);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(errorText);
            return result;
        }
    }

    static class MediaRouteProviderCreateRouteResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final MediaRouteProvider.CreateRouteResponse mCallback;

        MediaRouteProviderCreateRouteResponseParamsForwardToCallback(MediaRouteProvider.CreateRouteResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_ROUTE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                MediaRouteProviderCreateRouteResponseParams response = MediaRouteProviderCreateRouteResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.route, response.errorText);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaRouteProviderCreateRouteResponseParamsProxyToResponder implements MediaRouteProvider.CreateRouteResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaRouteProviderCreateRouteResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(MediaRoute route, String errorText) {
            MediaRouteProviderCreateRouteResponseParams _response = new MediaRouteProviderCreateRouteResponseParams();
            _response.route = route;
            _response.errorText = errorText;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CREATE_ROUTE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class MediaRouteProviderJoinRouteParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 40;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String mediaSource;
        public String presentationId;
        public String origin;
        public int tabId;
    
        private MediaRouteProviderJoinRouteParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderJoinRouteParams() {
            this(0);
        }
    
        public static MediaRouteProviderJoinRouteParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderJoinRouteParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderJoinRouteParams result = new MediaRouteProviderJoinRouteParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mediaSource = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.presentationId = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(24, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.tabId = decoder0.readInt(32);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mediaSource, 8, false);
            encoder0.encode(presentationId, 16, false);
            encoder0.encode(origin, 24, false);
            encoder0.encode(tabId, 32);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderJoinRouteParams other = (MediaRouteProviderJoinRouteParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaSource, other.mediaSource))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.presentationId, other.presentationId))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            if (this.tabId != other.tabId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaSource);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(presentationId);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(tabId);
            return result;
        }
    }

    static final class MediaRouteProviderJoinRouteResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public MediaRoute route;
        public String errorText;
    
        private MediaRouteProviderJoinRouteResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderJoinRouteResponseParams() {
            this(0);
        }
    
        public static MediaRouteProviderJoinRouteResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderJoinRouteResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderJoinRouteResponseParams result = new MediaRouteProviderJoinRouteResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                result.route = MediaRoute.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.errorText = decoder0.readString(16, true);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(route, 8, true);
            encoder0.encode(errorText, 16, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderJoinRouteResponseParams other = (MediaRouteProviderJoinRouteResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.route, other.route))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.errorText, other.errorText))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(route);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(errorText);
            return result;
        }
    }

    static class MediaRouteProviderJoinRouteResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final MediaRouteProvider.JoinRouteResponse mCallback;

        MediaRouteProviderJoinRouteResponseParamsForwardToCallback(MediaRouteProvider.JoinRouteResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(JOIN_ROUTE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                MediaRouteProviderJoinRouteResponseParams response = MediaRouteProviderJoinRouteResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.route, response.errorText);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaRouteProviderJoinRouteResponseParamsProxyToResponder implements MediaRouteProvider.JoinRouteResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaRouteProviderJoinRouteResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(MediaRoute route, String errorText) {
            MediaRouteProviderJoinRouteResponseParams _response = new MediaRouteProviderJoinRouteResponseParams();
            _response.route = route;
            _response.errorText = errorText;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    JOIN_ROUTE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class MediaRouteProviderCloseRouteParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String routeId;
    
        private MediaRouteProviderCloseRouteParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderCloseRouteParams() {
            this(0);
        }
    
        public static MediaRouteProviderCloseRouteParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderCloseRouteParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderCloseRouteParams result = new MediaRouteProviderCloseRouteParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.routeId = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(routeId, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderCloseRouteParams other = (MediaRouteProviderCloseRouteParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.routeId, other.routeId))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(routeId);
            return result;
        }
    }

    static final class MediaRouteProviderSendRouteMessageParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String mediaRouteId;
        public String message;
    
        private MediaRouteProviderSendRouteMessageParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderSendRouteMessageParams() {
            this(0);
        }
    
        public static MediaRouteProviderSendRouteMessageParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderSendRouteMessageParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderSendRouteMessageParams result = new MediaRouteProviderSendRouteMessageParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mediaRouteId = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.message = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mediaRouteId, 8, false);
            encoder0.encode(message, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderSendRouteMessageParams other = (MediaRouteProviderSendRouteMessageParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaRouteId, other.mediaRouteId))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.message, other.message))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaRouteId);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(message);
            return result;
        }
    }

    static final class MediaRouteProviderSendRouteMessageResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean sent;
    
        private MediaRouteProviderSendRouteMessageResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderSendRouteMessageResponseParams() {
            this(0);
        }
    
        public static MediaRouteProviderSendRouteMessageResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderSendRouteMessageResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderSendRouteMessageResponseParams result = new MediaRouteProviderSendRouteMessageResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sent = decoder0.readBoolean(8, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(sent, 8, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderSendRouteMessageResponseParams other = (MediaRouteProviderSendRouteMessageResponseParams) object;
            if (this.sent != other.sent)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sent);
            return result;
        }
    }

    static class MediaRouteProviderSendRouteMessageResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final MediaRouteProvider.SendRouteMessageResponse mCallback;

        MediaRouteProviderSendRouteMessageResponseParamsForwardToCallback(MediaRouteProvider.SendRouteMessageResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SEND_ROUTE_MESSAGE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                MediaRouteProviderSendRouteMessageResponseParams response = MediaRouteProviderSendRouteMessageResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.sent);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaRouteProviderSendRouteMessageResponseParamsProxyToResponder implements MediaRouteProvider.SendRouteMessageResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaRouteProviderSendRouteMessageResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean sent) {
            MediaRouteProviderSendRouteMessageResponseParams _response = new MediaRouteProviderSendRouteMessageResponseParams();
            _response.sent = sent;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SEND_ROUTE_MESSAGE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class MediaRouteProviderSendRouteBinaryMessageParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String mediaRouteId;
        public byte[] data;
    
        private MediaRouteProviderSendRouteBinaryMessageParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderSendRouteBinaryMessageParams() {
            this(0);
        }
    
        public static MediaRouteProviderSendRouteBinaryMessageParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderSendRouteBinaryMessageParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderSendRouteBinaryMessageParams result = new MediaRouteProviderSendRouteBinaryMessageParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mediaRouteId = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.data = decoder0.readBytes(16, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mediaRouteId, 8, false);
            encoder0.encode(data, 16, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderSendRouteBinaryMessageParams other = (MediaRouteProviderSendRouteBinaryMessageParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaRouteId, other.mediaRouteId))
                return false;
            if (!java.util.Arrays.equals(this.data, other.data))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaRouteId);
            result = prime * result + java.util.Arrays.hashCode(data);
            return result;
        }
    }

    static final class MediaRouteProviderSendRouteBinaryMessageResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean sent;
    
        private MediaRouteProviderSendRouteBinaryMessageResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderSendRouteBinaryMessageResponseParams() {
            this(0);
        }
    
        public static MediaRouteProviderSendRouteBinaryMessageResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderSendRouteBinaryMessageResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderSendRouteBinaryMessageResponseParams result = new MediaRouteProviderSendRouteBinaryMessageResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sent = decoder0.readBoolean(8, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(sent, 8, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderSendRouteBinaryMessageResponseParams other = (MediaRouteProviderSendRouteBinaryMessageResponseParams) object;
            if (this.sent != other.sent)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sent);
            return result;
        }
    }

    static class MediaRouteProviderSendRouteBinaryMessageResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final MediaRouteProvider.SendRouteBinaryMessageResponse mCallback;

        MediaRouteProviderSendRouteBinaryMessageResponseParamsForwardToCallback(MediaRouteProvider.SendRouteBinaryMessageResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SEND_ROUTE_BINARY_MESSAGE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                MediaRouteProviderSendRouteBinaryMessageResponseParams response = MediaRouteProviderSendRouteBinaryMessageResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.sent);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaRouteProviderSendRouteBinaryMessageResponseParamsProxyToResponder implements MediaRouteProvider.SendRouteBinaryMessageResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaRouteProviderSendRouteBinaryMessageResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean sent) {
            MediaRouteProviderSendRouteBinaryMessageResponseParams _response = new MediaRouteProviderSendRouteBinaryMessageResponseParams();
            _response.sent = sent;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    SEND_ROUTE_BINARY_MESSAGE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class MediaRouteProviderStartObservingMediaSinksParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String mediaSource;
    
        private MediaRouteProviderStartObservingMediaSinksParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderStartObservingMediaSinksParams() {
            this(0);
        }
    
        public static MediaRouteProviderStartObservingMediaSinksParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderStartObservingMediaSinksParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderStartObservingMediaSinksParams result = new MediaRouteProviderStartObservingMediaSinksParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mediaSource = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mediaSource, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderStartObservingMediaSinksParams other = (MediaRouteProviderStartObservingMediaSinksParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaSource, other.mediaSource))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaSource);
            return result;
        }
    }

    static final class MediaRouteProviderStopObservingMediaSinksParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String mediaSource;
    
        private MediaRouteProviderStopObservingMediaSinksParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderStopObservingMediaSinksParams() {
            this(0);
        }
    
        public static MediaRouteProviderStopObservingMediaSinksParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderStopObservingMediaSinksParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderStopObservingMediaSinksParams result = new MediaRouteProviderStopObservingMediaSinksParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.mediaSource = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(mediaSource, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderStopObservingMediaSinksParams other = (MediaRouteProviderStopObservingMediaSinksParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.mediaSource, other.mediaSource))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(mediaSource);
            return result;
        }
    }

    static final class MediaRouteProviderStartObservingMediaRoutesParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private MediaRouteProviderStartObservingMediaRoutesParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderStartObservingMediaRoutesParams() {
            this(0);
        }
    
        public static MediaRouteProviderStartObservingMediaRoutesParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderStartObservingMediaRoutesParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderStartObservingMediaRoutesParams result = new MediaRouteProviderStartObservingMediaRoutesParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class MediaRouteProviderStopObservingMediaRoutesParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private MediaRouteProviderStopObservingMediaRoutesParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderStopObservingMediaRoutesParams() {
            this(0);
        }
    
        public static MediaRouteProviderStopObservingMediaRoutesParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderStopObservingMediaRoutesParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderStopObservingMediaRoutesParams result = new MediaRouteProviderStopObservingMediaRoutesParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class MediaRouteProviderListenForRouteMessagesParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String routeId;
    
        private MediaRouteProviderListenForRouteMessagesParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderListenForRouteMessagesParams() {
            this(0);
        }
    
        public static MediaRouteProviderListenForRouteMessagesParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderListenForRouteMessagesParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderListenForRouteMessagesParams result = new MediaRouteProviderListenForRouteMessagesParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.routeId = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(routeId, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderListenForRouteMessagesParams other = (MediaRouteProviderListenForRouteMessagesParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.routeId, other.routeId))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(routeId);
            return result;
        }
    }

    static final class MediaRouteProviderListenForRouteMessagesResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public RouteMessage[] messages;
        public boolean error;
    
        private MediaRouteProviderListenForRouteMessagesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderListenForRouteMessagesResponseParams() {
            this(0);
        }
    
        public static MediaRouteProviderListenForRouteMessagesResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderListenForRouteMessagesResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderListenForRouteMessagesResponseParams result = new MediaRouteProviderListenForRouteMessagesResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.messages = new RouteMessage[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.messages[i1] = RouteMessage.decode(decoder2);
                    }
                }
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.error = decoder0.readBoolean(16, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            if (messages == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(messages.length, 8, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < messages.length; ++i0) {
                    encoder1.encode(messages[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            encoder0.encode(error, 16, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderListenForRouteMessagesResponseParams other = (MediaRouteProviderListenForRouteMessagesResponseParams) object;
            if (!java.util.Arrays.deepEquals(this.messages, other.messages))
                return false;
            if (this.error != other.error)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + java.util.Arrays.deepHashCode(messages);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(error);
            return result;
        }
    }

    static class MediaRouteProviderListenForRouteMessagesResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final MediaRouteProvider.ListenForRouteMessagesResponse mCallback;

        MediaRouteProviderListenForRouteMessagesResponseParamsForwardToCallback(MediaRouteProvider.ListenForRouteMessagesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(LISTEN_FOR_ROUTE_MESSAGES_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                MediaRouteProviderListenForRouteMessagesResponseParams response = MediaRouteProviderListenForRouteMessagesResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.messages, response.error);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaRouteProviderListenForRouteMessagesResponseParamsProxyToResponder implements MediaRouteProvider.ListenForRouteMessagesResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaRouteProviderListenForRouteMessagesResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(RouteMessage[] messages, Boolean error) {
            MediaRouteProviderListenForRouteMessagesResponseParams _response = new MediaRouteProviderListenForRouteMessagesResponseParams();
            _response.messages = messages;
            _response.error = error;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    LISTEN_FOR_ROUTE_MESSAGES_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class MediaRouteProviderStopListeningForRouteMessagesParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String routeId;
    
        private MediaRouteProviderStopListeningForRouteMessagesParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderStopListeningForRouteMessagesParams() {
            this(0);
        }
    
        public static MediaRouteProviderStopListeningForRouteMessagesParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderStopListeningForRouteMessagesParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderStopListeningForRouteMessagesParams result = new MediaRouteProviderStopListeningForRouteMessagesParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.routeId = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(routeId, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderStopListeningForRouteMessagesParams other = (MediaRouteProviderStopListeningForRouteMessagesParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.routeId, other.routeId))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(routeId);
            return result;
        }
    }

    static final class MediaRouteProviderOnPresentationSessionDetachedParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String routeId;
    
        private MediaRouteProviderOnPresentationSessionDetachedParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public MediaRouteProviderOnPresentationSessionDetachedParams() {
            this(0);
        }
    
        public static MediaRouteProviderOnPresentationSessionDetachedParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static MediaRouteProviderOnPresentationSessionDetachedParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            MediaRouteProviderOnPresentationSessionDetachedParams result = new MediaRouteProviderOnPresentationSessionDetachedParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.routeId = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(routeId, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            MediaRouteProviderOnPresentationSessionDetachedParams other = (MediaRouteProviderOnPresentationSessionDetachedParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.routeId, other.routeId))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(routeId);
            return result;
        }
    }

}

